import wx.svg
import base64
from enum import Enum
from io import BytesIO

from utils.config import Config
from utils.common.enums import Platform

class IconID(Enum):
    App_Default = 1

    Play = 10
    Pause = 11
    Close = 12
    Folder = 13
    Retry = 14
    Refresh = 15
    Setting = 16
    List = 17
    Info = 18
    Loading = 19
    Downloading = 20
    Complete = 21
    Tree_Structure = 22
    Cut = 23
    Convert = 24
    Audio = 25
    Back = 26
    Stop = 27
    Start_Recording = 30
    Stop_Recording = 31
    Rec = 32
    Search = 33
    Up = 34
    Down = 35
    Help = 36
    To_Top = 37
    To_Bottom = 38

class IconSize(Enum):
    SMALL = 1
    MEDIUM = 2
    LARGE = 3

    SMALL_EX = 4

class IconResource:
    resource = {
        1: "PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzMiIgaGVpZ2h0PSIzMiIgdmlld0JveD0iMCAwIDI0IDI0Ij48IS0tIEljb24gZnJvbSBTaW1wbGUgSWNvbnMgYnkgU2ltcGxlIEljb25zIENvbGxhYm9yYXRvcnMgLSBodHRwczovL2dpdGh1Yi5jb20vc2ltcGxlLWljb25zL3NpbXBsZS1pY29ucy9ibG9iL2RldmVsb3AvTElDRU5TRS5tZCAtLT48cGF0aCBmaWxsPSIjMDBhMWQ2IiBkPSJNMTcuODEzIDQuNjUzaC44NTRxMi4yNjYuMDggMy43NzMgMS41NzRRMjMuOTQ2IDcuNzIgMjQgOS45ODd2Ny4zNnEtLjA1NCAyLjI2Ni0xLjU2IDMuNzczYy0xLjUwNiAxLjUwNy0yLjI2MiAxLjUyNC0zLjc3MyAxLjU2SDUuMzMzcS0yLjI2Ni0uMDU0LTMuNzczLTEuNTZDLjA1MyAxOS42MTQuMDM2IDE4Ljg1OCAwIDE3LjM0N3YtNy4zNnEuMDU0LTIuMjY3IDEuNTYtMy43NnQzLjc3My0xLjU3NGguNzc0bC0xLjE3NC0xLjEyYTEuMjMgMS4yMyAwIDAgMS0uMzczLS45MDZxMC0uNTM0LjM3My0uOTA3bC4wMjctLjAyN3EuNC0uMzczLjkyLS4zNzN0LjkyLjM3M0w5LjY1MyA0LjQ0cS4xMDcuMTA2LjE4Ny4yMTNoNC4yNjdhLjguOCAwIDAgMSAuMTYtLjIxM2wyLjg1My0yLjc0N3EuNC0uMzczLjkyLS4zNzNjLjM0NyAwIC42NjIuMTUxLjkyOS40cy4zOTEuNTUxLjM5MS45MDdxMCAuNTMyLS4zNzMuOTA2ek01LjMzMyA3LjI0cS0xLjEyLjAyNy0xLjg4Ljc3M3EtLjc2Ljc0OC0uNzg2IDEuODk0djcuNTJxLjAyNiAxLjE0Ni43ODYgMS44OTN0MS44OC43NzNoMTMuMzM0cTEuMTItLjAyNiAxLjg4LS43NzN0Ljc4Ni0xLjg5M3YtNy41MnEtLjAyNi0xLjE0Ny0uNzg2LTEuODk0dC0xLjg4LS43NzN6TTggMTEuMTA3cS41NiAwIC45MzMuMzczcS4zNzUuMzc0LjQuOTZ2MS4xNzNxLS4wMjUuNTg2LS40Ljk2cS0uMzczLjM3NS0uOTMzLjM3NGMtLjU2LS4wMDEtLjY4NC0uMTI1LS45MzMtLjM3NHEtLjM3NS0uMzczLS40LS45NlYxMi40NHEwLS41Ni4zODYtLjk0N3EuMzg3LS4zODYuOTQ3LS4zODZtOCAwcS41NiAwIC45MzMuMzczcS4zNzUuMzc0LjQuOTZ2MS4xNzNxLS4wMjUuNTg2LS40Ljk2cS0uMzczLjM3NS0uOTMzLjM3NGMtLjU2LS4wMDEtLjY4NC0uMTI1LS45MzMtLjM3NHEtLjM3NS0uMzczLS40LS45NlYxMi40NHEuMDI1LS41ODYuNC0uOTZxLjM3My0uMzczLjkzMy0uMzczIi8+PC9zdmc+",
        10: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NTIiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMTAxLjUsNTIuNSBDIDIxNi42MzcsMTE5LjkwMyAzMzEuNjM3LDE4Ny41NyA0NDYuNSwyNTUuNUMgMzMxLjc0OSwzMjMuMjkzIDIxNi45MTYsMzkwLjk1OSAxMDIsNDU4LjVDIDEwMS41LDMyMy4xNjcgMTAxLjMzMywxODcuODM0IDEwMS41LDUyLjUgWiBNIDEyMi41LDkwLjUgQyAyMTYuMTQzLDE0NC45ODggMzA5LjQ3NiwxOTkuOTg4IDQwMi41LDI1NS41QyAzMDkuNywzMTAuNzM3IDIxNi43LDM2NS43MzcgMTIzLjUsNDIwLjVDIDEyMi41LDMxMC41MDIgMTIyLjE2NywyMDAuNTAyIDEyMi41LDkwLjUgWiIvPjwvZz4KPC9zdmc+Cg==",
        11: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MyIgZmlsbD0iIzAwMDAwMCIgZD0iTSAxMjEuNSw4MC41IEMgMTU2LjE2Nyw4MC41IDE5MC44MzMsODAuNSAyMjUuNSw4MC41QyAyMjUuNSwxOTcuMTY3IDIyNS41LDMxMy44MzMgMjI1LjUsNDMwLjVDIDE5MC44MzMsNDMwLjUgMTU2LjE2Nyw0MzAuNSAxMjEuNSw0MzAuNUMgMTIxLjUsMzEzLjgzMyAxMjEuNSwxOTcuMTY3IDEyMS41LDgwLjUgWiBNIDE0My41LDEwMi41IEMgMTYzLjUsMTAyLjUgMTgzLjUsMTAyLjUgMjAzLjUsMTAyLjVDIDIwMy41LDIwNC41IDIwMy41LDMwNi41IDIwMy41LDQwOC41QyAxODMuNSw0MDguNSAxNjMuNSw0MDguNSAxNDMuNSw0MDguNUMgMTQzLjUsMzA2LjUgMTQzLjUsMjA0LjUgMTQzLjUsMTAyLjUgWiIvPjwvZz4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MyIgZmlsbD0iIzAwMDAwMCIgZD0iTSAyODUuNSw4MC41IEMgMzIwLjE2Nyw4MC41IDM1NC44MzMsODAuNSAzODkuNSw4MC41QyAzODkuNSwxOTcuMTY3IDM4OS41LDMxMy44MzMgMzg5LjUsNDMwLjVDIDM1NC44MzMsNDMwLjUgMzIwLjE2Nyw0MzAuNSAyODUuNSw0MzAuNUMgMjg1LjUsMzEzLjgzMyAyODUuNSwxOTcuMTY3IDI4NS41LDgwLjUgWiBNIDMwNy41LDEwMi41IEMgMzI3LjUsMTAyLjUgMzQ3LjUsMTAyLjUgMzY3LjUsMTAyLjVDIDM2Ny41LDIwNC41IDM2Ny41LDMwNi41IDM2Ny41LDQwOC41QyAzNDcuNSw0MDguNSAzMjcuNSw0MDguNSAzMDcuNSw0MDguNUMgMzA3LjUsMzA2LjUgMzA3LjUsMjA0LjUgMzA3LjUsMTAyLjUgWiIvPjwvZz4KPC9zdmc+Cg==",
        12: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NDgiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gNzcuNSw2My41IEMgNzguMjM4OSw2My4zNjkgNzguOTA1Niw2My41MzU3IDc5LjUsNjRDIDEzOC4wMTQsMTIyLjY4IDE5Ni42OCwxODEuMTggMjU1LjUsMjM5LjVDIDMxNC4zMiwxODEuMTggMzcyLjk4NiwxMjIuNjggNDMxLjUsNjRDIDQzMi4xNjcsNjMuMzMzMyA0MzIuODMzLDYzLjMzMzMgNDMzLjUsNjRDIDQzOCw2OC41IDQ0Mi41LDczIDQ0Nyw3Ny41QyA0NDcuNjY3LDc4LjE2NjcgNDQ3LjY2Nyw3OC44MzMzIDQ0Nyw3OS41QyAzODguMzIsMTM4LjAxNCAzMjkuODIsMTk2LjY4IDI3MS41LDI1NS41QyAzMjkuODIsMzE0LjMyIDM4OC4zMiwzNzIuOTg2IDQ0Nyw0MzEuNUMgNDQ3LjY2Nyw0MzIuMTY3IDQ0Ny42NjcsNDMyLjgzMyA0NDcsNDMzLjVDIDQ0Mi41LDQzOCA0MzgsNDQyLjUgNDMzLjUsNDQ3QyA0MzIuODMzLDQ0Ny42NjcgNDMyLjE2Nyw0NDcuNjY3IDQzMS41LDQ0N0MgMzcyLjk4NiwzODguMzIgMzE0LjMyLDMyOS44MiAyNTUuNSwyNzEuNUMgMTk2LjY4LDMyOS44MiAxMzguMDE0LDM4OC4zMiA3OS41LDQ0N0MgNzguODMzMyw0NDcuNjY3IDc4LjE2NjcsNDQ3LjY2NyA3Ny41LDQ0N0MgNzMsNDQyLjUgNjguNSw0MzggNjQsNDMzLjVDIDYzLjMzMzMsNDMyLjgzMyA2My4zMzMzLDQzMi4xNjcgNjQsNDMxLjVDIDEyMi42OCwzNzIuOTg2IDE4MS4xOCwzMTQuMzIgMjM5LjUsMjU1LjVDIDE4MS4xOCwxOTYuNjggMTIyLjY4LDEzOC4wMTQgNjQsNzkuNUMgNjMuMzMzMyw3OC44MzMzIDYzLjMzMzMsNzguMTY2NyA2NCw3Ny41QyA2OC43MDMzLDcyLjk2NDUgNzMuMjAzMyw2OC4yOTc5IDc3LjUsNjMuNSBaIi8+PC9nPgo8L3N2Zz4K",
        13: "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",
        14: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NDUiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjUxLjUsMTkuNSBDIDM0NS4yMjYsMjEuMjU4MiA0MTUuNzI2LDYyLjI1ODIgNDYzLDE0Mi41QyA0OTcuMTgyLDIwOS4zMjIgNTAwLjUxNSwyNzcuNjU1IDQ3MywzNDcuNUMgNDM1LjI2Niw0MjkuMjA5IDM3MS43NjYsNDc2LjcwOSAyODIuNSw0OTBDIDE4NS4xOTYsNDk3LjI1OSAxMDkuMzYyLDQ2MC43NTkgNTUsMzgwLjVDIDEzLjMyNzQsMzA5LjAzNiA4LjMyNzM3LDIzNS4wMzYgNDAsMTU4LjVDIDU1LjY2MiwxMjQuMzQ5IDc4LjE2Miw5NS41MTU0IDEwNy41LDcyQyA4My44MzMzLDcxLjY2NjcgNjAuMTY2Nyw3MS4zMzMzIDM2LjUsNzFDIDI5LjEyNDUsNjYuNzMyNSAyNy42MjQ1LDYwLjg5OTIgMzIsNTMuNUMgMzMuMjU0Nyw1Mi43ODk0IDM0LjQyMTQsNTEuOTU2IDM1LjUsNTFDIDcxLjQ5ODUsNTAuNSAxMDcuNDk4LDUwLjMzMzMgMTQzLjUsNTAuNUMgMTQzLjY2Nyw4NS44MzQ5IDE0My41LDEyMS4xNjggMTQzLDE1Ni41QyAxMzkuOTAzLDE2My4xMzIgMTM0LjczNiwxNjUuMjk5IDEyNy41LDE2M0MgMTI0LjgxMywxNjEuMTI1IDEyMi45NzksMTU4LjYyNSAxMjIsMTU1LjVDIDEyMS42NjcsMTMzLjE2NyAxMjEuMzMzLDExMC44MzMgMTIxLDg4LjVDIDU1LjYwNjYsMTQ1LjAxMyAzMC42MDY2LDIxNi4wMTMgNDYsMzAxLjVDIDY4LjUsMzg4IDEyMyw0NDIuNSAyMDkuNSw0NjVDIDI5NS45MTQsNDgwLjUzNCAzNjcuNDE0LDQ1NS4wMzQgNDI0LDM4OC41QyA0NjguNjU4LDMyOC41MzYgNDgwLjY1OCwyNjIuNTM2IDQ2MCwxOTAuNUMgNDM3LjYzNSwxMjQuODAyIDM5NC4xMzUsNzkuMzAxNyAzMjkuNSw1NEMgMzAzLjE0OCw0NS4yODQ3IDI3Ni4xNDgsNDAuMjg0NyAyNDguNSwzOUMgMjQyLjYyOSwzMS4zOTczIDI0My42MjksMjQuODk3MyAyNTEuNSwxOS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        15: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NDUiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjQwLjUsMTkuNSBDIDMyMS4yNzcsMTYuNjc0MiAzODcuNDQzLDQ2LjAwNzYgNDM5LDEwNy41QyA0MzkuMzMzLDgzLjgzMzMgNDM5LjY2Nyw2MC4xNjY3IDQ0MCwzNi41QyA0NDQuMjY3LDI5LjEyNDUgNDUwLjEwMSwyNy42MjQ1IDQ1Ny41LDMyQyA0NTguMjExLDMzLjI1NDcgNDU5LjA0NCwzNC40MjE0IDQ2MCwzNS41QyA0NjAuNSw3MS40OTg1IDQ2MC42NjcsMTA3LjQ5OCA0NjAuNSwxNDMuNUMgNDI1LjE2NSwxNDMuNjY3IDM4OS44MzIsMTQzLjUgMzU0LjUsMTQzQyAzNDcuODY4LDEzOS45MDMgMzQ1LjcwMSwxMzQuNzM2IDM0OCwxMjcuNUMgMzQ5Ljg3NSwxMjQuODEzIDM1Mi4zNzUsMTIyLjk3OSAzNTUuNSwxMjJDIDM3Ny44MzMsMTIxLjY2NyA0MDAuMTY3LDEyMS4zMzMgNDIyLjUsMTIxQyAzNjUuOTk1LDU1LjYxMTQgMjk0Ljk5NSwzMC42MTE0IDIwOS41LDQ2QyAxMjcuODM0LDY2LjY2NjUgNzQuMzMzNiwxMTcuMTY3IDQ5LDE5Ny41QyAyOS4wNTIzLDI4MC4yMjYgNDguODg1NiwzNTEuNzI2IDEwOC41LDQxMkMgMTczLjUxMiw0NjguNDcgMjQ3LjE3OCw0ODMuNDcgMzI5LjUsNDU3QyA0MDcuMzg1LDQyNS4xMDEgNDUzLjU1MiwzNjcuNjAxIDQ2OCwyODQuNUMgNDY4LjkzNCwyNzMuMTU2IDQ2OS45MzQsMjYxLjgyMyA0NzEsMjUwLjVDIDQ3NC44MjEsMjQ0LjYwNyA0NzkuOTg4LDI0My4xMDcgNDg2LjUsMjQ2QyA0ODguMzc4LDI0Ny41NDMgNDg5Ljg3OCwyNDkuMzc2IDQ5MSwyNTEuNUMgNDkwLjI0MiwzMzkuNDg5IDQ1My40MDksNDA3LjY1NSAzODAuNSw0NTZDIDMxNC43ODEsNDk0LjY3MiAyNDUuNzgxLDUwMS42NzIgMTczLjUsNDc3QyA5OC40NDcxLDQ0Ni45NDcgNDkuNjEzNywzOTMuMTE0IDI3LDMxNS41QyA2LjQ3MDMzLDIyMi40MzkgMzAuNjM3LDE0My4yNzIgOTkuNSw3OEMgMTQwLjE2NCw0My4zODU0IDE4Ny4xNjQsMjMuODg1NCAyNDAuNSwxOS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        16: "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",
        17: "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",
        18: "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",
        19: "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",
        20: "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+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NDUiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjQwLjUsMTkuNSBDIDMzNy45NjMsMTcuNDY2NiA0MTEuNzk3LDU3Ljc5OTkgNDYyLDE0MC41QyA0OTUuNDA4LDIwMy45ODkgNTAwLjQwOCwyNjkuNjU2IDQ3NywzMzcuNUMgNDQzLjU0LDQxOS42MjEgMzgzLjM3Myw0NjkuNzg4IDI5Ni41LDQ4OEMgMjEwLjE0Myw1MDAuNDQgMTM3LjMxLDQ3NC45NCA3OCw0MTEuNUMgMTkuOTIzLDM0MC40MzMgNS4yNTYzNSwyNjEuMSAzNCwxNzMuNUMgNjQuMDUyOCw5OC40NDcxIDExNy44ODYsNDkuNjEzNyAxOTUuNSwyN0MgMjEwLjQ4MywyMy41MDU5IDIyNS40ODMsMjEuMDA1OSAyNDAuNSwxOS41IFogTSAyNTMuNSw0MC41IEMgMzM1LjM1OSw0Mi45OTI0IDM5Ny44NTksNzguNjU5MSA0NDEsMTQ3LjVDIDQ3Ni41MDQsMjEzLjI0NSA0NzkuMTcxLDI4MC4yNDUgNDQ5LDM0OC41QyA0MTIuNSw0MTguMzYzIDM1NSw0NTguNTMgMjc2LjUsNDY5QyAxOTUuMzkzLDQ3NC4wMTkgMTMwLjIyNiw0NDQuNTE5IDgxLDM4MC41QyAzNS4xNjU0LDMxMS4zNTUgMjguODMyMSwyMzguNjg4IDYyLDE2Mi41QyAxMDIuNzIyLDg1Ljg3MTkgMTY2LjU1Niw0NS4yMDUzIDI1My41LDQwLjUgWiIvPjwvZz4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzciIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjUyLjUsMTIxLjUgQyAyNTkuMjA2LDEyMC41NTkgMjYzLjcwNiwxMjMuMjI1IDI2NiwxMjkuNUMgMjY2LjMzMywyMDMuNSAyNjYuNjY3LDI3Ny41IDI2NywzNTEuNUMgMjg4LjUsMzMwIDMxMCwzMDguNSAzMzEuNSwyODdDIDM0MC45NDQsMjgzLjUzIDM0Ni42MSwyODYuNjk2IDM0OC41LDI5Ni41QyAzNDguMjM3LDI5OS4wMjggMzQ3LjQwNCwzMDEuMzYxIDM0NiwzMDMuNUMgMzE4LjE2NywzMzEuMzMzIDI5MC4zMzMsMzU5LjE2NyAyNjIuNSwzODdDIDI1Ny44MzMsMzkwLjMzMyAyNTMuMTY3LDM5MC4zMzMgMjQ4LjUsMzg3QyAyMjAuMzMzLDM1OC44MzMgMTkyLjE2NywzMzAuNjY3IDE2NCwzMDIuNUMgMTYwLjQzMywyOTIuOTYyIDE2My42LDI4Ny4yOTUgMTczLjUsMjg1LjVDIDE3NS42MzQsMjg1LjUxNSAxNzcuNjM0LDI4Ni4wMTUgMTc5LjUsMjg3QyAyMDEsMzA4LjUgMjIyLjUsMzMwIDI0NCwzNTEuNUMgMjQ0LjMzMywyNzcuNSAyNDQuNjY3LDIwMy41IDI0NSwxMjkuNUMgMjQ2LjM1MywxMjUuNjUgMjQ4Ljg1MywxMjIuOTgzIDI1Mi41LDEyMS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        21: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NDUiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjQwLjUsMTkuNSBDIDMzNS40NTYsMTcuMzg0OCA0MDguMjksNTYuMDUxNSA0NTksMTM1LjVDIDQ5NS4wNTUsMjAwLjEwOSA1MDEuMDU1LDI2Ny40NDIgNDc3LDMzNy41QyA0NDMuNTQsNDE5LjYyMSAzODMuMzczLDQ2OS43ODggMjk2LjUsNDg4QyAyMTAuMTM4LDUwMC40MzggMTM3LjMwNSw0NzQuOTM4IDc4LDQxMS41QyAxOS45MjMsMzQwLjQzMyA1LjI1NjM1LDI2MS4xIDM0LDE3My41QyA2NC4wNTI4LDk4LjQ0NzEgMTE3Ljg4Niw0OS42MTM3IDE5NS41LDI3QyAyMTAuNDgzLDIzLjUwNTkgMjI1LjQ4MywyMS4wMDU5IDI0MC41LDE5LjUgWiBNIDI1My41LDQwLjUgQyAzMzUuMzU5LDQyLjk5MjQgMzk3Ljg1OSw3OC42NTkxIDQ0MSwxNDcuNUMgNDc2LjUwNCwyMTMuMjQ1IDQ3OS4xNzEsMjgwLjI0NSA0NDksMzQ4LjVDIDQxMi41LDQxOC4zNjMgMzU1LDQ1OC41MyAyNzYuNSw0NjlDIDE5NS4zOTMsNDc0LjAxOSAxMzAuMjI2LDQ0NC41MTkgODEsMzgwLjVDIDM1LjE3MjgsMzExLjMxNSAyOC44Mzk1LDIzOC42NDggNjIsMTYyLjVDIDEwMi43MjIsODUuODcxOSAxNjYuNTU2LDQ1LjIwNTMgMjUzLjUsNDAuNSBaIi8+PC9nPgo8Zz48cGF0aCBzdHlsZT0ib3BhY2l0eTowLjkzNyIgZmlsbD0iIzAwMDAwMCIgZD0iTSAzNTQuNSwxNTIuNSBDIDM2Ni40NDUsMTUyLjM4IDM3MC42MTIsMTU4LjA0NiAzNjcsMTY5LjVDIDMyNy42OTYsMjI3LjYzNyAyODguMTk2LDI4NS42MzcgMjQ4LjUsMzQzLjVDIDIxNi44NDksMzE0LjM1IDE4NS4zNDksMjg1LjAxNyAxNTQsMjU1LjVDIDE1MC45MzksMjQyLjg5NiAxNTUuNzcyLDIzNy43MjkgMTY4LjUsMjQwQyAxOTQsMjYzLjUgMjE5LjUsMjg3IDI0NSwzMTAuNUMgMjgwLDI1OC44MzMgMzE1LDIwNy4xNjcgMzUwLDE1NS41QyAzNTEuNjUyLDE1NC42MDEgMzUzLjE1MiwxNTMuNjAxIDM1NC41LDE1Mi41IFoiLz48L2c+Cjwvc3ZnPgo=",
        22: "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",
        23: "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",
        24: "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",
        25: "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",
        26: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzQiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMzU2LjUsMzkuNSBDIDM2OC44OTQsNDEuOTYyMSAzNzEuNzI3LDQ4LjYyODggMzY1LDU5LjVDIDI5OS42NTMsMTI0LjY4IDIzNC40ODYsMTkwLjAxNCAxNjkuNSwyNTUuNUMgMjM0LjQ4NiwzMjAuOTg2IDI5OS42NTMsMzg2LjMyIDM2NSw0NTEuNUMgMzcxLjQ0Nyw0NjEuMzk3IDM2OS4xMTMsNDY4LjA2NCAzNTgsNDcxLjVDIDM1Ni4xMTIsNDcxLjIwNCAzNTQuMjc4LDQ3MC43MDQgMzUyLjUsNDcwQyAyODMsNDAwLjUgMjEzLjUsMzMxIDE0NCwyNjEuNUMgMTQyLDI1Ny41IDE0MiwyNTMuNSAxNDQsMjQ5LjVDIDIxMy41LDE4MCAyODMsMTEwLjUgMzUyLjUsNDFDIDM1NC4wNTgsNDAuNzkgMzU1LjM5MSw0MC4yOSAzNTYuNSwzOS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        27: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MyIgZmlsbD0iIzAwMDAwMCIgZD0iTSA4MC41LDgwLjUgQyAxOTcuMTY3LDgwLjUgMzEzLjgzMyw4MC41IDQzMC41LDgwLjVDIDQzMC41LDE5Ny4xNjcgNDMwLjUsMzEzLjgzMyA0MzAuNSw0MzAuNUMgMzEzLjgzMyw0MzAuNSAxOTcuMTY3LDQzMC41IDgwLjUsNDMwLjVDIDgwLjUsMzEzLjgzMyA4MC41LDE5Ny4xNjcgODAuNSw4MC41IFogTSAxMDIuNSwxMDIuNSBDIDIwNC41LDEwMi41IDMwNi41LDEwMi41IDQwOC41LDEwMi41QyA0MDguNSwyMDQuNSA0MDguNSwzMDYuNSA0MDguNSw0MDguNUMgMzA2LjUsNDA4LjUgMjA0LjUsNDA4LjUgMTAyLjUsNDA4LjVDIDEwMi41LDMwNi41IDEwMi41LDIwNC41IDEwMi41LDEwMi41IFoiLz48L2c+Cjwvc3ZnPgo=",
        30: "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",
        31: "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",
        32: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCEtLSBHZW5lcmF0b3I6IGh0dHBzOi8vZXpnaWYuY29tL3BuZy10by1zdmcgLS0+CjxzdmcgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNTYiIGhlaWdodD0iMjU2Ij4KPHBhdGggZD0iTTAgMCBDMTkuMzcgMTYuNjQgMzEuOSAzNi4wNyAzOC4zMSA2MC42OSBDMzguNjggNjIuMDkgMzguNjggNjIuMDkgMzkuMDYgNjMuNTIgQzQ1LjA5IDkxLjk1IDM3Ljg5IDEyMS42NiAyMi4zMSAxNDUuNjkgQzYgMTY4LjIxIC0xNi4wMSAxODIuNzQgLTQyLjY5IDE4OS42OSBDLTQ0LjA5IDE5MC4wNiAtNDQuMDkgMTkwLjA2IC00NS41MiAxOTAuNDMgQy03My45NSAxOTYuNDYgLTEwMy42NiAxODkuMjcgLTEyNy42OSAxNzMuNjkgQy0xNTAuMjEgMTU3LjM3IC0xNjQuNzQgMTM1LjM3IC0xNzEuNjkgMTA4LjY5IEMtMTcxLjkzIDEwNy43NSAtMTcyLjE4IDEwNi44MiAtMTcyLjQzIDEwNS44NiBDLTE3OC40NiA3Ny40MiAtMTcxLjI3IDQ3LjcyIC0xNTUuNjkgMjMuNjkgQy0xMzkuMzcgMS4xNiAtMTE3LjM3IC0xMy4zNiAtOTAuNjkgLTIwLjMxIEMtODkuNzUgLTIwLjU2IC04OC44MiAtMjAuOCAtODcuODYgLTIxLjA2IEMtNTcuNTMgLTI3LjQ5IC0yNC4xMyAtMTkuMTcgMCAwIFogIiBmaWxsPSIjRUIzNjQzIiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgxOTQuNjg3NSw0My4zMTI1KSIvPgo8L3N2Zz4K",
        33: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45NTMiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjA0LjUsMjkuNSBDIDI3Ni44MzcsMjguNTY5IDMzMS4zMzcsNTguOTAyMyAzNjgsMTIwLjVDIDM5Ny4yNzcsMTc4LjcxMSAzOTYuMjc3LDIzNi4zNzggMzY1LDI5My41QyAzNTkuODYzLDMwMS42MTMgMzU0LjM2MywzMDkuNDQ2IDM0OC41LDMxN0MgMzkxLjc2NCwzNjIuMjY1IDQzNS43NjQsNDA2LjkzMiA0ODAuNSw0NTFDIDQ3MC42NjcsNDYwLjgzMyA0NjAuODMzLDQ3MC42NjcgNDUxLDQ4MC41QyA0MDYuMzA2LDQzNS40NzIgMzYxLjMwNiwzOTAuODA2IDMxNiwzNDYuNUMgMjYxLjY3OCwzODIuNTcyIDIwNC4xNzgsMzg4LjQwNSAxNDMuNSwzNjRDIDc3LjUxMjQsMzMxLjI5IDQyLjg0NTgsMjc3Ljk1NyAzOS41LDIwNEMgNDIuMTM0MiwxMzkuNzAzIDcwLjEzNDIsOTAuMDM2NSAxMjMuNSw1NUMgMTQ4LjY3NCw0MC4zMjkgMTc1LjY3NCwzMS44MjkgMjA0LjUsMjkuNSBaIE0gMTk4LjUsNTEuNSBDIDI3MS44NTYsNDguNDA5NyAzMjQuMzU2LDc5Ljc0MyAzNTYsMTQ1LjVDIDM3Ni45NDEsMjAxLjg0MyAzNjkuMjc0LDI1My44NDMgMzMzLDMwMS41QyAyODguOTg4LDM1MC42MSAyMzQuODIyLDM2Ny4xMSAxNzAuNSwzNTFDIDExMC4yOTcsMzMwLjEyNSA3NC40NjM3LDI4OC4yOTEgNjMsMjI1LjVDIDU2Ljk3NjIsMTYwLjA1NiA4MS4xNDI5LDEwOS4yMjMgMTM1LjUsNzNDIDE1NS4xOTYsNjEuNzEzIDE3Ni4xOTYsNTQuNTQ2MyAxOTguNSw1MS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        34: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzMiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjU0LjUsNzcuNSBDIDI5NS43NSwxMTcuMjQ5IDMzNi41ODMsMTU3LjU4MiAzNzcsMTk4LjVDIDM4MC41OSwyMDcuOTg5IDM3Ny40MjMsMjEzLjY1NiAzNjcuNSwyMTUuNUMgMzY0Ljk3MiwyMTUuMjM3IDM2Mi42MzksMjE0LjQwNCAzNjAuNSwyMTNDIDMyOS4zMzMsMTgxLjgzMyAyOTguMTY3LDE1MC42NjcgMjY3LDExOS41QyAyNjYuNjY3LDIyMC4xNjcgMjY2LjMzMywzMjAuODMzIDI2Niw0MjEuNUMgMjY0LjgzNiw0MjcuMTYgMjYxLjMzNiw0MzAuMTYgMjU1LjUsNDMwLjVDIDI0OS42NjQsNDMwLjE2IDI0Ni4xNjQsNDI3LjE2IDI0NSw0MjEuNUMgMjQ0LjY2NywzMjAuODMzIDI0NC4zMzMsMjIwLjE2NyAyNDQsMTE5LjVDIDIxMi44MzMsMTUwLjY2NyAxODEuNjY3LDE4MS44MzMgMTUwLjUsMjEzQyAxNDAuODA2LDIxNy43MjEgMTM0LjgwNiwyMTQuODg4IDEzMi41LDIwNC41QyAxMzIuNTE1LDIwMi4zNjYgMTMzLjAxNSwyMDAuMzY2IDEzNCwxOTguNUMgMTc0LjM2OCwxNTguMjk5IDIxNC41MzUsMTE3Ljk2NSAyNTQuNSw3Ny41IFoiLz48L2c+Cjwvc3ZnPgo=",
        35: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzQiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjUyLjUsODAuNSBDIDI1OS4yMDYsNzkuNTU4NyAyNjMuNzA2LDgyLjIyNTQgMjY2LDg4LjVDIDI2Ni4zMzMsMTg5LjUgMjY2LjY2NywyOTAuNSAyNjcsMzkxLjVDIDI5OC4xNjcsMzYwLjMzMyAzMjkuMzMzLDMyOS4xNjcgMzYwLjUsMjk4QyAzNzAuMTk0LDI5My4yNzkgMzc2LjE5NCwyOTYuMTEyIDM3OC41LDMwNi41QyAzNzguNDg1LDMwOC42MzQgMzc3Ljk4NSwzMTAuNjM0IDM3NywzMTIuNUMgMzM2LjY1MywzNTMuMDE0IDI5Ni4xNTMsMzkzLjM0NyAyNTUuNSw0MzMuNUMgMjE1LjE4LDM5My42OCAxNzUuMDE0LDM1My42OCAxMzUsMzEzLjVDIDEzMC45MzYsMzAxLjU3NyAxMzUuMTAyLDI5Ni4wNzcgMTQ3LjUsMjk3QyAxNDguODMzLDI5Ny42NjcgMTUwLjE2NywyOTguMzMzIDE1MS41LDI5OUMgMTgyLjMzMywzMjkuODMzIDIxMy4xNjcsMzYwLjY2NyAyNDQsMzkxLjVDIDI0NC4zMzMsMjkwLjUgMjQ0LjY2NywxODkuNSAyNDUsODguNUMgMjQ2LjM1Myw4NC42NDk5IDI0OC44NTMsODEuOTgzMiAyNTIuNSw4MC41IFoiLz48L2c+Cjwvc3ZnPgo=",
        36: "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",
        37: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzMiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gMjU0LjUsNjYuNSBDIDMyNi40MTcsMTM2LjkxNiAzOTcuOTE3LDIwNy45MTYgNDY5LDI3OS41QyA0NzMuNDIyLDI4OS4yNDIgNDcwLjQyMiwyOTUuMjQyIDQ2MCwyOTcuNUMgNDU3Ljc1NSwyOTYuODYzIDQ1NS41ODgsMjk2LjAzIDQ1My41LDI5NUMgMzg3LjY1MywyMjguOTg2IDMyMS42NTMsMTYzLjE1MyAyNTUuNSw5Ny41QyAxODkuMzQ3LDE2My4xNTMgMTIzLjM0NywyMjguOTg2IDU3LjUsMjk1QyA0OC4wODA4LDI5OS4zMTYgNDIuMDgwOCwyOTYuNDgzIDM5LjUsMjg2LjVDIDQwLjAzNjEsMjg0LjA1OCA0MC44Njk0LDI4MS43MjUgNDIsMjc5LjVDIDExMy4wMzUsMjA4LjYzMiAxODMuODY4LDEzNy42MzIgMjU0LjUsNjYuNSBaIi8+PC9nPgo8Zz48cGF0aCBzdHlsZT0ib3BhY2l0eTowLjkzMiIgZmlsbD0iIzAwMDAwMCIgZD0iTSAyNTQuNSwxOTkuNSBDIDMyNi40MTcsMjY5LjkxNiAzOTcuOTE3LDM0MC45MTYgNDY5LDQxMi41QyA0NzMuMzU4LDQyMS45MzQgNDcwLjUyNSw0MjcuOTM0IDQ2MC41LDQzMC41QyA0NTguMDU4LDQyOS45NjQgNDU1LjcyNSw0MjkuMTMxIDQ1My41LDQyOEMgMzg3LjY1MywzNjEuOTg2IDMyMS42NTMsMjk2LjE1MyAyNTUuNSwyMzAuNUMgMTg5LjM0NywyOTYuMTUzIDEyMy4zNDcsMzYxLjk4NiA1Ny41LDQyOEMgNDguMDY2MSw0MzIuMzU4IDQyLjA2NjEsNDI5LjUyNSAzOS41LDQxOS41QyA0MC4wMzYxLDQxNy4wNTggNDAuODY5NCw0MTQuNzI1IDQyLDQxMi41QyAxMTMuMDM1LDM0MS42MzIgMTgzLjg2OCwyNzAuNjMyIDI1NC41LDE5OS41IFoiLz48L2c+Cjwvc3ZnPgo=",
        38: "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgd2lkdGg9IjUxMnB4IiBoZWlnaHQ9IjUxMnB4IiBzdHlsZT0ic2hhcGUtcmVuZGVyaW5nOmdlb21ldHJpY1ByZWNpc2lvbjsgdGV4dC1yZW5kZXJpbmc6Z2VvbWV0cmljUHJlY2lzaW9uOyBpbWFnZS1yZW5kZXJpbmc6b3B0aW1pemVRdWFsaXR5OyBmaWxsLXJ1bGU6ZXZlbm9kZDsgY2xpcC1ydWxlOmV2ZW5vZGQiIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIj4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzIiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gNDguNSw4MC41IEMgNTEuNjg4Myw4MC42MTc4IDU0LjY4ODMsODEuNDUxMSA1Ny41LDgzQyAxMjMuMzQ3LDE0OS4wMTQgMTg5LjM0NywyMTQuODQ3IDI1NS41LDI4MC41QyAzMjEuNjUzLDIxNC44NDcgMzg3LjY1MywxNDkuMDE0IDQ1My41LDgzQyA0NjIuOTM0LDc4LjY0MjEgNDY4LjkzNCw4MS40NzU0IDQ3MS41LDkxLjVDIDQ3MC45NjQsOTMuOTQxNyA0NzAuMTMxLDk2LjI3NTEgNDY5LDk4LjVDIDM5Ny45ODYsMTY5LjY4IDMyNi44MiwyNDAuNjggMjU1LjUsMzExLjVDIDE4NC4xOCwyNDAuNjggMTEzLjAxNCwxNjkuNjggNDIsOTguNUMgMzcuOTU4NSw5MC4xMTY2IDQwLjEyNTIsODQuMTE2NiA0OC41LDgwLjUgWiIvPjwvZz4KPGc+PHBhdGggc3R5bGU9Im9wYWNpdHk6MC45MzQiIGZpbGw9IiMwMDAwMDAiIGQ9Ik0gNDkuNSwyMTMuNSBDIDUyLjI1MjksMjE0LjAyMiA1NC45MTk2LDIxNC44NTYgNTcuNSwyMTZDIDEyMy4zNDcsMjgyLjAxNCAxODkuMzQ3LDM0Ny44NDcgMjU1LjUsNDEzLjVDIDMyMS42NTMsMzQ3Ljg0NyAzODcuNjUzLDI4Mi4wMTQgNDUzLjUsMjE2QyA0NjIuOTM0LDIxMS42NDIgNDY4LjkzNCwyMTQuNDc1IDQ3MS41LDIyNC41QyA0NzAuOTY0LDIyNi45NDIgNDcwLjEzMSwyMjkuMjc1IDQ2OSwyMzEuNUMgMzk3Ljk4NiwzMDIuNjggMzI2LjgyLDM3My42OCAyNTUuNSw0NDQuNUMgMTg0LjE4LDM3My42OCAxMTMuMDE0LDMwMi42OCA0MiwyMzEuNUMgMzcuODAzLDIyMi41NzIgNDAuMzAzLDIxNi41NzIgNDkuNSwyMTMuNSBaIi8+PC9nPgo8L3N2Zz4K"
    }
    
class Icon:
    @classmethod
    def get_icon_bitmap(cls, icon_id: IconID, icon_size: IconSize | wx.Size = IconSize.SMALL):
        decode_string = base64.b64decode(IconResource.resource.get(icon_id.value))

        if Config.Sys.dark_mode:
            decode_string = decode_string.replace(b"#000000", b"#ffffff")
            
        img: wx.svg.SVGimage = wx.svg.SVGimage.CreateFromBytes(BytesIO(decode_string).getvalue())

        size = cls.get_scale_size(icon_size)

        scale = min(size.width / img.width, size.height / img.height)
        
        return img.ConvertToBitmap(scale = scale, width = size.width, height = size.height)
    
    @classmethod
    def get_app_icon_bitmap(cls, icon_id: IconID):
        match icon_id:
            case IconID.App_Default:
                base64_string = "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"

                return wx.Image(BytesIO(base64.b64decode(base64_string)), type = wx.BITMAP_TYPE_ICO).ConvertToBitmap()

    @staticmethod
    def get_scale_size(icon_size: IconSize | wx.Size):
        if isinstance(icon_size, wx.Size):
            return icon_size
        
        match icon_size:
            case IconSize.SMALL:
                size = wx.Size(16, 16)
            
            case IconSize.MEDIUM:
                size = wx.Size(48, 48)
            
            case IconSize.LARGE:
                size = wx.Size(128, 128)

            case IconSize.SMALL_EX:
                match Platform(Config.Sys.platform):
                    case Platform.Windows:
                        size = wx.Size(16, 16)

                    case Platform.Linux | Platform.macOS:
                        size = wx.Size(16, 16)

        size.Scale(Config.Sys.dpi_scale_factor, Config.Sys.dpi_scale_factor)

        return size
        